package edu.columbia.cs.itx.dsadmin;

import javax.swing.*;
import javax.swing.text.*;
import oracle.jdeveloper.layout.*;
import java.awt.*;
import java.awt.event.*;

public class UserEditorDialog extends JDialog {
  final String[] accessLevelStrings = {"User", "Server", "Administrator"};

  JPanel mainPanel = new JPanel();
  BoxLayout2 boxLayout21 = new BoxLayout2();
  JPanel fieldPanel = new JPanel();
  JPanel buttonPanel = new JPanel();
  JLabel idLabel = new JLabel();
  GridBagLayout gridBagLayout1 = new GridBagLayout();
  JTextField idField = new JTextField();
  JLabel extLabel = new JLabel();
  JTextField extField = new JTextField();
  JLabel pass1Label = new JLabel();
  JPasswordField pass1Field = new JPasswordField();
  JLabel pass2Label = new JLabel();
  JPasswordField pass2Field = new JPasswordField();
  JLabel accessLevelLabel = new JLabel();
  JComboBox accessLevelList = new JComboBox(accessLevelStrings);
  JLabel custMsgLabel = new JLabel();
  JTextArea custMsgArea = new JTextArea();
  JButton cancelButton = new JButton();
  JButton addButton = new JButton();

  
  public UserEditorDialog(Frame parent, String title, boolean modal) {
    super(parent, title, modal);
    try  {
      jbInit();
      pack();
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  private void jbInit() throws Exception {
    mainPanel.setLayout(boxLayout21);
    boxLayout21.setAxis(BoxLayout.Y_AXIS);
    fieldPanel.setLayout(gridBagLayout1);
    idLabel.setText("User ID");
    idField.setText("");
    extLabel.setText("Extension");
    extField.setText("");
    pass1Label.setText("Password");
    pass1Field.setText("");
    pass2Label.setText("Password, again");
    pass2Field.setText("");
    custMsgLabel.setText("Custom Message");
    custMsgArea.setLineWrap(true);
    custMsgArea.setColumns(20);
    custMsgArea.setRows(3);
    custMsgArea.setText("");
    cancelButton.setText("Cancel");
    addButton.setText("Add");
    getContentPane().add(mainPanel);
    cancelButton.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        dispose();
      }
    });
    
    mainPanel.add(fieldPanel, null);
    JLabel[] labels = {idLabel, extLabel, pass1Label, pass2Label, accessLevelLabel, custMsgLabel};
    JComponent[] components = {idField, extField, pass1Field, pass2Field, accessLevelList, custMsgArea};
    addLabelTextRows(labels, components, gridBagLayout1, fieldPanel);

    mainPanel.add(buttonPanel, null);
    buttonPanel.add(addButton, null);
    buttonPanel.add(cancelButton, null);
  }

  
  public UserEditorDialog() {
    this(null, "", false);
  }

  private void addLabelTextRows(JLabel[] labels, JComponent[] components,
  GridBagLayout gridbag, Container container) {
    Insets insets = new Insets (2, 0, 2, 0);
    GridBagConstraints c = new GridBagConstraints();
    c.anchor = GridBagConstraints.EAST;
    int numLabels = labels.length;

    for (int i = 0; i < numLabels; i++) {
      c.gridwidth = GridBagConstraints.RELATIVE;
      c.fill = GridBagConstraints.NONE;
      c.weightx = 0.0;
      gridbag.setConstraints(labels[i], c);
      container.add(labels[i]);

      c.gridwidth = GridBagConstraints.REMAINDER;
      c.fill = GridBagConstraints.HORIZONTAL;
      c.weightx = 1.0;
      c.insets = insets;
      gridbag.setConstraints(components[i], c);
      container.add(components[i]);
    }
  }

  public void addAddButtonActionListener(ActionListener l) {
    addButton.addActionListener(l);
  }

  public String getID() {
    return idField.getText();
  }

  public String getExtension() {
    return extField.getText();
  }

  public String getPassword() {
    return new String(pass1Field.getPassword());
  }

  public String getVerifyingPassword() {
    return new String(pass2Field.getPassword());
  }

  public int getAccessLevelListIndex() {
    return accessLevelList.getSelectedIndex();
  }

  public String getCustomMessage() {
    return custMsgArea.getText();
  }
}


